 ; Ŀ
 ;   Lout - write the names of layers in a drawing to a Cdf file.          
 ;   Copyright 1994, 2009 by Rocket Software Ltd.                          
 ;   The information superhighway - another attempt to ignore the innate   
 ;   lust for hard copy.                                                   
 ; 
 (DEFUN C:LOUT (/ pos tt rewind clay clam fnam)
 ; Ŀ
 ;   Get the drawing name and set pointer Pos to the end of the string.    
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove the path.                                                      
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 ; Ŀ
 ;   TT now contains the drawing file name.  Now make a string of the      
 ;   layer names separated by commas.  The comma removal code seems to be  
 ;   unneccessary since one can't make a layer name containing a comma.    
 ; 
  (setq rewind T)
  (while (setq clay (tblnext "layer" rewind))
         (setq rewind ())
         (setq clam (cdr (assoc 2 clay)))
         (setq tt (strcat tt "," clam)))
 ; Ŀ
 ;   And write the string to the log file.                                 
 ; 
  (setq fnam (open "layer.log" "a"))
  (write-line tt fnam)
  (close fnam)
 (princ))